<?php

date_default_timezone_set('Asia/Kolkata');

// Logging setup
$logFile = __DIR__ . '/gelluonduhogu_cron_wingo.log';
function log_message($msg) {
    global $logFile;
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] $msg\n", FILE_APPEND);
}

$startTime = microtime(true);
log_message("Script started.");

// Lock file logic
$lockFile = __DIR__ . '/gelluonduhogu_cron_wingo.lock';
$lock = fopen($lockFile, 'c');
if (!$lock || !flock($lock, LOCK_EX | LOCK_NB)) {
    log_message("Another cron is still running. Exiting.");
    exit("Another cron is still running.\n");
}

function waitForSecond($desiredSecond) {
    while (true) {
        $currentSecond = date('s');
        if ($currentSecond == $desiredSecond) {
            break;
        }
        usleep(100000); 
    }
}

waitForSecond('00');

include("serive/samparka.php");
include("nayakaphalitansa_mulaka_unohs.php");

$currentDate = date('Ymd');
$timeInSeconds = time() % 86400; 
$sequenceNumber = intval($timeInSeconds / 60); 
$uniqueSequence = str_pad($sequenceNumber, 4, '0', STR_PAD_LEFT); 

$bartamankalakrama = $currentDate . "10001" . $uniqueSequence;
$bartamankalakrama = $bartamankalakrama + 1;

$prathama = $bartamankalakrama; 
$sesa = $currentDate . "10001" . sprintf("%04d", ceil(86400 / 60));
$tarika = date('Y-m-d H:i:s');

log_message("Checking latest atadaaidi...");
$dekhakalakrama = mysqli_query($conn,"select atadaaidi from `gelluonduhogu` order by kramasankhye desc limit 1");
if (!$dekhakalakrama) {
    log_message("Query error: " . mysqli_error($conn));
}
$kaladhadi = mysqli_num_rows($dekhakalakrama);
$kalakramadhadi = mysqli_fetch_array($dekhakalakrama);

$inserted = false;
$attempts = 0;
$max_attempts = 5;

while (!$inserted && $attempts < $max_attempts) {
    if($kaladhadi == null){
        log_message("No previous atadaaidi found. Inserting $bartamankalakrama.");
        $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$bartamankalakrama."','".$tarika."')");
        if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
    }
    else if($prathama > $kalakramadhadi['atadaaidi']){
        log_message("Truncating table and inserting $prathama.");
        $katiba = mysqli_query($conn,"TRUNCATE TABLE `gelluonduhogu`");
        $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$prathama."','".$tarika."')");
        if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
    }
    else{
        $parabartikrama = $kalakramadhadi['atadaaidi'] + 1;
        log_message("Inserting incremented atadaaidi: $parabartikrama.");
        $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$parabartikrama."','".$tarika."')");
        if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
    }

    if ($tathya) {
        $inserted = true;
        log_message("Insert successful.");
    } else {
        if (mysqli_errno($conn) == 1062) { // 1062 = duplicate entry
            log_message("Duplicate entry error. Incrementing bartamankalakrama and retrying.");
            $bartamankalakrama++;
            $prathama = $bartamankalakrama;
            $kalakramadhadi['atadaaidi'] = $bartamankalakrama - 1;
            $attempts++;
        } else {
            log_message("Other DB error. Breaking loop.");
            break;
        }
    }
}

$safa_shonu = mysqli_query($conn, "DELETE FROM gelluonduhogu_zehn_zehn_1");
if (!$safa_shonu) log_message("Cleanup error: " . mysqli_error($conn));

// Release lock
flock($lock, LOCK_UN);
fclose($lock);
unlink($lockFile);

$endTime = microtime(true);
$duration = round($endTime - $startTime, 3);
log_message("Script finished. Total execution time: {$duration}s\n");
?>